using System;
using System.Linq;
using System.Collections.Generic;

class Program
{
    struct Vec
    {
        public long x, y;
        public double angle;
        public int idx;
    }

    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        Vec[] a = new Vec[n];

        for (int i = 0; i < n; i++)
        {
            var parts = Console.ReadLine().Split();
            long x = long.Parse(parts[0]);
            long y = long.Parse(parts[1]);
            a[i] = new Vec
            {
                x = x,
                y = y,
                angle = Math.Atan2(y, x),
                idx = i + 1
            };
        }

        Array.Sort(a, (u, v) => u.angle.CompareTo(v.angle));

        Vec[] b = new Vec[2 * n];
        for (int i = 0; i < n; i++)
        {
            b[i] = a[i];
            b[i + n] = new Vec
            {
                x = a[i].x,
                y = a[i].y,
                angle = a[i].angle + 2 * Math.PI,
                idx = a[i].idx
            };
        }

        long sx = 0, sy = 0;
        long best = 0;
        int bl = 0, br = -1;

        int l = 0;
        for (int r = 0; r < 2 * n; r++)
        {
            sx += b[r].x;
            sy += b[r].y;

            while (b[r].angle - b[l].angle > Math.PI)
            {
                sx -= b[l].x;
                sy -= b[l].y;
                l++;
            }

            long cur = sx * sx + sy * sy;
            if (cur > best)
            {
                best = cur;
                bl = l;
                br = r;
            }
        }

        List<int> res = new List<int>();
        for (int i = bl; i <= br; i++)
            res.Add(b[i].idx);

        Console.WriteLine(res.Count);
        Console.WriteLine(string.Join(" ", res));
    }
}